
module Event_Command_Convert_Module

  attr_accessor :indent

  attr_reader :name
  attr_reader :param
  attr_reader :related
  
  def related_parent
    @related_parent[@indent]
  end
  def related_parent=(related_parent)
    @related_parent[@indent] = related_parent unless @related
  end
  def event_id(name)
    @event_names.index(name)
  end
  def event_name(id)
    @event_names[id]
  end

  # LN^[hc̎擾
  def get_character_id(value)
    if value == 'vC['
      return -1
    elsif value == '̃Cxg'
      return 0
    elsif value =~ /\[(.+?)\]/
      return event_id($1)
    end
    return event_id(value)
  end
  def get_character_name(id)
    case id
    when -1
      return 'vC['
    when 0
      return '̃Cxg'
    end
    return 'Cxg[' + event_name(id) + ']'
  end
    
  COMMENT_PREFIX       = '#'   # Rgis̕ȂRgj
  EVENT_PREFIX         = ''  # Cxg
  RELATED_EVENT_PREFIX = 'F'  # ֘ACxg
  EVENT_SEPARATOR      = 'F'  # Cxg
  INDENT_STRING        = '@'  # Cfg
  
  # e̒
  EVENT_PREFIX_LEN         = EVENT_PREFIX.length
  RELATED_EVENT_PREFIX_LEN = RELATED_EVENT_PREFIX.length
  EVENT_SEPARATOR_LEN      = EVENT_SEPARATOR.length
  INDENT_STRING_LEN        = INDENT_STRING.length

  MSG_OPT_POSITION = ['','','']
  MSG_OPT_FRAME = ['\\','\\']
    
  VARIABLE_OPERATIONS = ['=','+=','-=','*=','/=','%=']
  VARIABLE_ITEMS = ['萔','ϐ','','ACe','AN^[','Gl~[','LN^[','̑']
  VARIABLE_ACTOR_OPERATION = ['x','EXP','HP','SP','MaxHP','MaxSP','r','p','f','','U','h','@h','C']
  VARIABLE_ENEMY_OPERATION = ['HP','SP','MaxHP','MaxSP','r','p','f','','U','h','@h','C']
  VARIABLE_CHARACTER_OPERATION = ['XW','YW','','XW','YW','n`^O']
  VARIABLE_ETC_OPERATION = ['}bvID','p[eBl','S[h','','vC','^C}[','Z[u']

  DATA = {}
  DATA_OPTS = {}
  NAMES = {}
  CODE = {}
  # Cxgǂݍ݃W[
  module Event_Element_Reader
    module_function
    
    # ǂݔ΂sH
    def skip_line?(line)
      if line =~ /^#{COMMENT_PREFIX}/
        return true
      end
      if line.strip == ""
        return true
      end
      return false
    end
  
    # Cxg֘ACxg̓T
    # return:: index,related
    def find_start_index(data)
      i1 = data.index(EVENT_PREFIX)
      i2 = data.index(RELATED_EVENT_PREFIX)
      # ǂ
      if i1.nil? and i2.nil?
        # TODO: \G[
        return 0,false
      end
      # Е̂
      if i1.nil? 
        return i2,true
      end
      if i2.nil?
        return i1,false
      end
      # ꍇ
      if i1 < i2
        return i1,false
      else
        return i2,true
      end
      # TODO: \G[
      return 0,false
    end

    def parse_element(line)
      # Cxg֘ACxg̓T
      index_s,related = find_start_index(line)

      # Cfg
      indent = index_s / INDENT_STRING_LEN
      
      # Gg̒o(番܂)
      index_s += EVENT_PREFIX_LEN
      index_e = line.index(EVENT_SEPARATOR,index_s)
      if index_e.nil?
        # ꍇ́Af[^Ō܂
        name = line[index_s,line.length]
      else
        name = line[index_s,index_e - index_s]
        # Ăꍇ́AGg̒l擾
        param = line[index_e + EVENT_SEPARATOR_LEN,line.length]
      end
      return indent,related,name.strip,param
    end
  end

  class ConvertBase
    def initialize(options)
      @options = options
    end
    
    def split_param(param)
      param.split(/,|A/).collect {|c| c.strip}
    end

    def create_line(indent,name,parameters)
      out = ''
      out << indent_string(indent)
      out << name
      unless parameters.empty?
        out << EVENT_SEPARATOR << parameters.join(',')
      end
      return out
    end
    def create_command(code, indent, parameters)
      RPG::EventCommand.new(code, indent, parameters)
    end
    def indent_string(i)
      INDENT_STRING * i
    end

    def import(ecc,line)
      ecc.related_parent = self
      parameters = import_parameters(ecc,line)
      case parameters
      when String
        parameters = [parameters]
      end
      code = import_code(ecc,line)
      return create_command(code,ecc.indent,parameters)
    end
    def import_code(ecc,line)
      @options[:code]
    end
    def import_parameters(ecc,line)
      return [ecc.param.toutf8] unless ecc.param.nil?
      return []
    end

    def export(ecc,event_command)
      ecc.related_parent = self
      parameters = export_parameters(ecc,event_command)
      case parameters
      when String
        parameters = [parameters]
      end
      name = export_name(ecc,event_command)
      return create_line(event_command.indent,name,parameters)
    end
    def export_name(ecc,event_command)
      if ecc.related
        name = RELATED_EVENT_PREFIX + NAMES[event_command.code]
      else
        name = EVENT_PREFIX + NAMES[event_command.code]
      end
    end
    def export_parameters(ecc,event_command)
      event_command.parameters.collect() {|o| o.to_s.tosjis}
    end
  end

  # ύXpNX\bh
  module ClassMethods
    def add_event(op,&block)
      op = {
        :related_code=>[]
      }.update(op)
      event_data = Class.new(ConvertBase,&block)
      DATA[op[:code]] = event_data
      DATA_OPTS[op[:code]] = op
      op[:related_code].each() do |code|
        DATA[code] = event_data
        DATA_OPTS[code] = op
        NAMES[code] = (INDENT_STRING * (op[:names][0].length / 2))
      end
      NAMES[op[:code]] = op[:names][0]
      op[:names].each() do |name|
        CODE[name] = op[:code]
      end
    end
  end

  # Game_Picture ւ̃W[f
  def self.included(klass)
    # NX\bh̒ǉ
    klass.extend(ClassMethods)
  end

  # Cxgf[^cN[f[^ɃC|[g 
  def imports(map_id,event_names,lines)
    @map_id = map_id
    @event_names = event_names
    @indent = 0
    @related_parent = []
    @command_list = []
    @lines = lines
    @line_index = 0
    while not end_line?
      line = next_line()
      @command_list.push import(line)
    end
    return @command_list
  end
  def end_line?
    while @lines.size > @line_index and Event_Element_Reader.skip_line?(@lines[@line_index])
      @line_index += 1
    end
    return @lines.size <= @line_index
  end
  def next_line()
    while @lines.size > @line_index and Event_Element_Reader.skip_line?(@lines[@line_index])
      @line_index += 1
    end
    line = @lines[@line_index]
    @line_index += 1
    return line
  end

  def import(line)
    indent,@related,@name,@param = Event_Element_Reader.parse_element(line)
    code = CODE[@name]
    if @related
      @related_parent[@indent].import(self,line)
    else
      if DATA[code].nil?
        Log.error("no DATA [#{code}] [#{line}] [#{@name}]")
        return
      end
      DATA[code].new(DATA_OPTS[code]).import(self,line)
    end
  end
  
  # Cxgf[^cN[f[^GNX|[g 
  def exports(map_id,event_names,list)
    out = ''
    @map_id = map_id
    @event_names = event_names
    @related_parent = []
    list.each() do |cmd|
      out << export(self,cmd) << "\n"
    end
    return out
  end
  def export(data,event_command)
    @indent = event_command.indent
    if DATA[event_command.code].nil?
      Log.error("no DATA [#{event_command.code}]")
      return ''
    end
    code = event_command.code
    @related = DATA_OPTS[code][:related_code].include?(code)
    if @related
      @related_parent[@indent].export(self,event_command)
    else
      DATA[code].new(DATA_OPTS[code]).export(data,event_command)
    end
  end
  
end

class Event_Command_Convert
  include Event_Command_Convert_Module
  
  add_event(:code=>0,:names=>['']) do
    def import(ecc,line)
      res = super(ecc,line)
      ecc.indent -= 1 if ecc.indent > 0
      return res
    end
  end

  add_event(:code=>101,:names=>[''],:related_code=>[401]) do
    def import_code(ecc,line)
      if ecc.related
        return 401
      end
      super
    end
    def import_parameters(ecc,line)
      [ecc.param.toutf8]
    end
  end
  
  add_event(:code=>102,:names=>['I̕\'],:related_code=>[402,403,404]) do
    def import(ecc,line)
      res = super(ecc,line)
      if ecc.related and ecc.name != 'I'
        ecc.indent += 1
      else
        @event_command = res
      end
      return res
    end
    def import_code(ecc,line)
      if ecc.related
        if ecc.name == 'I'
          return 404
        elsif ecc.name =~ /LZ̏ꍇ/
          return 403
        elsif ecc.name =~ /̏ꍇ/
          return 402
        end
      end
      super
    end
    def import_parameters(ecc,line)
      unless ecc.related
        choices = ecc.param.split(/,|A/).collect {|c| c.strip}
        return [choices,0]
      else
        if ecc.name =~ /LZ̏ꍇ/
          @event_command.parameters[1] = 5
          return []
        elsif ecc.name =~ /\[?(.+)\]?̏ꍇ(\*?)/
          select_value = $1.strip
          select_index = @event_command.parameters[0].index(select_value)
          if $2 == "*"
            @event_command.parameters[1] = select_index + 1
          end
          return [select_index,select_value]
        else
          @event_command.parameters[0] = @event_command.parameters[0].collect() {|o|o.toutf8}
          return []
        end
      end
    end
    def export_name(ecc,event_command)
      case event_command.code
      when 402
        select_index,select_value = event_command.parameters
        cancel = ''
        if @event_command.parameters[1] != 0 and @event_command.parameters[1] == select_index + 1
          cancel = '*'
        end
        select = select_value.tosjis
        return RELATED_EVENT_PREFIX + select + '̏ꍇ' + cancel
      when 403
        return RELATED_EVENT_PREFIX + 'LZ̏ꍇ'
      when 404
        return RELATED_EVENT_PREFIX + 'I'
      end
      super(ecc,event_command)
    end
    def export_parameters(ecc,event_command)
      case event_command.code
      when 102
        @event_command = event_command
        return event_command.parameters[0].collect() {|o|o.tosjis}
      end
      return []
    end
  end
  
  add_event(:code=>103,:names=>['l͂̏']) do
    def import_parameters(ecc,line)
      variable_id = 1
      digits_max = 1
      if ecc.param =~ /\[(.+?)\]/
        variable_id = Event_Compiler_Util.variable_id($1)
      end
      if ecc.param =~ /([0-9])/
        digits_max = [[$1.to_i,1].max,8].min
      end
      [variable_id,digits_max]
    end
    def export_parameters(ecc,event_command)
      variable_id,digits_max = event_command.parameters
      name = Event_Compiler_Util.variable_name(variable_id)
      "[#{name}]#{digits_max}"
    end
  end
  
  add_event(:code=>104,:names=>['̓IvVύX']) do
    def import_parameters(ecc,line)
      position,frame = split_param(ecc.param)
      position = MSG_OPT_POSITION.index(position) or 0
      frame = MSG_OPT_FRAME.index(frame) or 0
      [position,frame]
    end
    def export_parameters(ecc,event_command)
      position,frame = event_command.parameters
      [MSG_OPT_POSITION[position],MSG_OPT_FRAME[frame]]
    end
  end

  add_event(:code=>105,:names=>['{^͂̏']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.empty?
        Log.error("{^͂̏:p[^[Ȃ")
        return []
      end
      variable_id = Event_Compiler_Util.variable_id(parameters[0])
      if variable_id < 0
        # TODO G[
        Log.error("{^͂̏:ϐu#{parameters[0]}v܂")
        return []
      end
      return [variable_id]
    end
    def export_parameters(ecc,event_command)
      variable_id = event_command.parameters[0]
      return Event_Compiler_Util.variable_name(variable_id)
    end
  end

  add_event(:code=>106,:names=>['EFCg']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.empty?
        Log.error("EFCg:p[^[Ȃ")
        return []
      end
      [parameters[0].to_i]
    end
  end
  
  add_event(:code=>108,:names=>['','Rg'])


  OPERATIONS = ['==','>=','<=','>','<','!=']
  CONDITION_TYPES = {
    0 => {
      :name => 'XCb`',
      :import => proc do |ecc,parameters|
        id = Event_Compiler_Util.parse_switch_id(ecc.param)
        val = Event_Compiler_Util.parse_switch_value(ecc.param[/==.*/])
        parameters.push id
        parameters.push val
      end,
      :export => proc do |ecc,parameters|
        id,val = parameters
        name = Event_Compiler_Util.switch_name(id)
        "[#{name}]==#{val ? 'ON' : 'OFF'}"
      end
    },
    1 => {
      :name => 'ϐ',
      :import => proc do |ecc,parameters|
        values = ecc.param.split(/(#{Regexp.union(OPERATIONS)})/).collect {|v| v.strip}
        id = Event_Compiler_Util.variable_id(values[0])
        ope = OPERATIONS.index(values[1])
        if values[2] =~ /^[0-9]+$/
          val = values[2].to_i
          type = 0
        elsif values[2] =~ /ϐ/
          val = Event_Compiler_Util.variable_id(values[2])
          type = 1
        end
        parameters.push id
        parameters.push type
        parameters.push val
        parameters.push ope
      end,
      :export => proc do |ecc,parameters|
        id,type,val,ope = parameters
        name = Event_Compiler_Util.variable_name(id)
        if type == 1
          val = 'ϐ[' + Event_Compiler_Util.variable_name(val) + ']'
        end 
        "[#{name}]#{OPERATIONS[ope]}#{val}"
      end
    },
    2 => {
      :name => 'ZtXCb`',
      :import => proc do |ecc,parameters|
        values = ecc.param.split(/==/).collect {|v| v.strip}
        if values.size == 2
          if values[0] =~ /ZtXCb`([ABCD])/
            parameters.push $1
          end
          if values[1] == "ON"
            parameters.push 0
          elsif values[1] == "OFF"
            parameters.push 1
          end
        end
      end,
      :export => proc do |ecc,parameters|
        name,val = parameters
        "#{name}==#{val == 0 ? 'ON' : 'OFF'}"
      end
    },
    3 => {
      :name => '^C}[',
      :import => proc do |ecc,parameters|
        # ^C}[[0:00]ȏ
        values = ecc.param.toutf8.split(/[\[\]:]/).collect {|v| v.strip}
        if values.size == 4
          min = values[1]
          sec = values[2]
          if min =~ /^[0-9]+$/ and sec =~ /^[0-9]+$/
            parameters.push(min.to_i * 60 + sec.to_i)
          else
            parameters.push 0
          end
          if values[3].tosjis =~ /ȏ/
            parameters.push 0
          else
            parameters.push 1
          end
        end
      end,
      :export => proc do |ecc,parameters|
        times,flag = parameters
        sec = times % 60
        min = (times - sec) / 60
        "[#{min}:#{'%02d' % sec}]#{flag == 0 ? 'ȏ' : 'ȉ' }"
      end
    },
    4 => {
      :name => 'AN^[',
      :import => proc do |ecc,parameters|
        values = ecc.param.split(/\s*\s*/,2)
        if values.size != 2
          parameters.concat([1,0,1])
          return
        end
        actor_id = Event_Compiler_Util.actor_id(values[0])
        case values[1]
        when /#{Regexp.escape('p[eBɂ')}/
          type = 0
          value = 1
        when /O\[(.+?)\]ɂȂĂ/
          type = 1
          value = $1
        when /\[(.+?)\]Kς/
          type = 2
          value = Event_Compiler_Util.skill_id($1)
        when /\[(.+?)\]𑕔/
          name = $1
          type = 3
          value = Event_Compiler_Util.weapon_id(name)
        when /h\[(.+?)\]𑕔/
          name = $1
          type = 4
          value = Event_Compiler_Util.armor_id(name)
        when /\[(.+?)\]ɂȂĂ/
          name = $1
          type = 5
          value = Event_Compiler_Util.state_id(name)
        when /\[(.+?)\]ɂȂĂȂ/ # IWi
          name = $1
          state_id = Event_Compiler_Util.state_id(name)
          # XNvgɕύX
          parameters.clear
          parameters.push 12 # XNvg
          parameters.push "not $game_actors[#{actor_id}].states.include?(#{state_id})"
          return
        else
          Log.error("FAN^[(#{element.value})")
          return
        end
        parameters.push actor_id
        parameters.push type
        parameters.push value
      end,
      :export => proc do |ecc,parameters|
        actor_id,type,value = parameters
        actor_name = Event_Compiler_Util.actor_name(actor_id)
        case type
        when 0  # p[eBɂ
          return "[#{actor_name}]p[eBɂ"
        when 1  # O
          return "[#{actor_name}]O[#{value}]ɂȂĂ"
        when 2  # XL
          value = Event_Compiler_Util.skill_name(value)
          return "[#{actor_name}][#{value}]Kς"
        when 3  # 
          value = Event_Compiler_Util.weapon_name(value)
          return "[#{actor_name}][#{value}]𑕔"
        when 4  # h
          value = Event_Compiler_Util.armor_name(value)
          return "[#{actor_name}]h[#{value}]𑕔"
        when 5  # Xe[g
          value = Event_Compiler_Util.state_name(value)
          return "[#{actor_name}][#{value}]ɂȂĂ"
        end
        return ""
      end
    },
    5 => {
      :name => 'Gl~[',
      :import => proc do |ecc,parameters|
        values = ecc.param.split(/\s*\s*/,2)
        if values.size != 2
          parameters.concat([0,0])
          return
        end
        troop_index = 0
        if values[0] =~ /\[([1-8])\]/
          troop_index = $1.to_i - 1
        end
        case values[1]
        when /oĂ/
          cond_type = 0  # oĂ
        when /\[(.+?)\]ɂȂĂ/
          cond_type = 1  # Xe[g
          state_id = Event_Compiler_Util.state_id($1)
        end
        parameters.push troop_index
        parameters.push cond_type
        parameters.push state_id if not state_id.nil?
      end,
      :export => proc do |ecc,parameters|
        troop_index,cond_type,state_id = parameters
        troop_index += 1
        case cond_type
        when 0 # oĂ
          return "[#{troop_index}]oĂ"
        when 1 # Xe[g
          name = Event_Compiler_Util.state_name(state_id)
          return "[#{troop_index}][#{name}]ɂȂĂ"
        end
      end
    },
    6 => {
      :name => ['vC[','̃Cxg','Cxg'],
      :import => proc do |ecc,parameters|
        values = ecc.param.split(/\s*\s*/,2)
        if values.size != 2
          parameters.concat([-1,2]) # vC[Ă
          return
        end
        chara = ecc.get_character_id(values[0])
        if values[1] =~ Regexp.union(%w(   E))
          direction = Event_Compiler_Util.direction($&)
        end
        parameters.concat([chara,direction])
      end,
      :export => proc do |ecc,names,parameters|
        chara,direction = parameters
        chara = ecc.get_character_name(chara)
        direction = Event_Compiler_Util.direction_name(direction)
        [chara,"#{direction}Ă"]
      end
    },
    7 => {
      :name => 'S[h',
      :import => proc do |ecc,parameters|
        if ecc.param =~ /#{Regexp.escape('S[h')}\s*([0-9]+?)\s*(#{Regexp.union('ȏ','ȉ')})/
          parameters.push($1.to_i)
          parameters.push($2 == "ȏ" ? 0 : 1)
        end
      end,
      :export => proc do |ecc,parameters|
        gold,flag = parameters
        flag = (flag == 0 ? 'ȏ' : 'ȉ')
        "#{gold}#{flag}"
      end
    },
    8 => {
      :name => 'ACe',
      :import => proc do |ecc,parameters|
        if ecc.param =~ /\[(.+?)\]#{Regexp.escape('Ă')}/
          parameters.push Event_Compiler_Util.item_id($1)
        end
     end,
      :export => proc do |ecc,parameters|
        id = parameters[0]
        name = Event_Compiler_Util.item_name(id)
        "[#{name}]Ă"
      end
    },
    9 => {
      :name => '',
      :import => proc do |ecc,parameters|
        if ecc.param =~ /\[(.+?)\]#{Regexp.escape('Ă')}/
          parameters.push Event_Compiler_Util.weapon_id($1)
        end
      end,
      :export => proc do |ecc,parameters|
        id = parameters[0]
        name = Event_Compiler_Util.weapon_name(id)
        "[#{name}]Ă"
      end
    },
    10 => {
      :name => 'h',
      :import => proc do |ecc,parameters|
        if ecc.param =~ /\[(.+?)\]#{Regexp.escape('Ă')}/
          parameters.push Event_Compiler_Util.armor_id($1)
        end
      end,
      :export => proc do |ecc,parameters|
        id = parameters[0]
        name = Event_Compiler_Util.armor_name(id)
        "[#{name}]Ă"
      end
    },
    11 => {
      :name => '{^',
      :import => proc do |ecc,parameters|
        if ecc.param =~ /\[(.+?)\]#{Regexp.escape('Ă')}/
          parameters.push Event_Compiler_Util.button_id($1)
        end
      end,
      :export => proc do |ecc,parameters|
        id = parameters[0]
        name = Event_Compiler_Util.button_name(id)
        "[#{name}]Ă"
      end
    },
    12 => {
      :name => 'XNvg',
      :import => proc do |ecc,parameters|
        values = ecc.param.split(/F/).collect {|s|s.strip}
        if values.size == 2
          parameters.push values[1].toutf8
        end
      end,
      :export => proc do |ecc,parameters|
        'F' + parameters[0].tosjis
      end
    }
  }
  
  add_event(:code=>111,:names=>[''],:related_code=>[411,412]) do
    def import(ecc,line)
      res = super(ecc,line)
      if ecc.name != 'I'
        ecc.indent += 1
      end
      unless ecc.related
        @event_command = res
      end
      return res
    end
    def import_code(ecc,line)
      if ecc.related
        case ecc.name
        when /I/
          return 412
        when /ȊO/,/ȊȌꍇ/
          return 411
        else
          Log.error("F^CvG[#{ecc.name}")
        end
      end
      super(ecc,line)
    end
    def import_parameters(ecc,line)
      if ecc.related
        return []
      end
      condition_type = -1
      condition_proc = nil
      CONDITION_TYPES.each() do |ctype,prop|
        [*prop[:name]].each() do |name|
        if ecc.param =~ /^#{Regexp.escape(name)}/
          condition_type = ctype
          condition_proc = prop[:import]
          break
        end
        end
      end
      if condition_proc.nil?
        Log.error("F^CvG[#{element.data}")
        return next_accept(element)
      end
      parameters = []
      parameters.push condition_type
      condition_proc.call(ecc,parameters)
      parameters
    end
    def export_name(ecc,event_command)
      case event_command.code
      when 411
        return RELATED_EVENT_PREFIX + 'ȊȌꍇ'
      when 412
        return RELATED_EVENT_PREFIX + 'I'
      end
      super(ecc,event_command)
    end
    def export_parameters(ecc,event_command)
      if ecc.related
        return []
      end
      condition_type,*parameters = event_command.parameters
      cprop = CONDITION_TYPES[condition_type]
      case cprop[:export].arity
      when 2
        name = cprop[:name]
        param = cprop[:export].call(ecc,parameters)
      when 3
        name, param = cprop[:export].call(ecc,cprop[:name],parameters)
      end
      return name + param
    end
  end
  
  add_event(:code=>112,:names=>['[v'],:related_code=>[413]) do
    def import(ecc,line)
      res = super(ecc,line)
      unless ecc.related
        ecc.indent += 1
      end
      return res
    end
    def import_code(ecc,line)
      if ecc.related
        return 413
      end
      super(ecc,line)
    end
    def export_name(ecc,event_command)
      if ecc.related
        case event_command.code
        when 413
          return RELATED_EVENT_PREFIX + 'ȏJԂ'
        end
      end
      super(ecc,event_command)
    end
  end
  
  add_event(:code=>113,:names=>['[v̒f'])
  add_event(:code=>115,:names=>['Cxg̒f'])
  add_event(:code=>116,:names=>['Cxg̈ꎞ'])

  add_event(:code=>117,:names=>['RCxg']) do
    def import_parameters(ecc,line)
      id = Event_Compiler_Util.parse_common_event_id(ecc.param)
      [id]
    end
    def export_parameters(ecc,event_command)
      id = event_command.parameters[0]
      Event_Compiler_Util.common_event_name(id)
    end
  end
  
  add_event(:code=>118,:names=>['x'])
  add_event(:code=>119,:names=>['xWv'])
  
  add_event(:code=>121,:names=>['XCb`̑','XCb`']) do
    def import_parameters(ecc,line)
      values = ecc.param.gsub(/\[|\]/,'').split(/=/).collect {|v| v.strip}
      if values.size != 2
        return []
      end
      switchs = values[0].split(/\.\./).collect {|v| v.strip}
      eid = sid = Event_Compiler_Util.switch_id(switchs[0])
      eid = Event_Compiler_Util.switch_id(switchs[1]) if switchs.size == 2
      flag = Event_Compiler_Util.parse_switch_value(values[1])
      return [sid,eid,flag]
    end
    def export_parameters(ecc,event_command)
      sid,eid,flag = event_command.parameters
      flag_str = Event_Compiler_Util.switch_value_string(flag)
      if sid == eid
        sname = Event_Compiler_Util.switch_name(sid)
        return "[#{sname}]=#{flag_str}"
      else
        sname = Event_Compiler_Util.switch_name(sid)
        ename = Event_Compiler_Util.switch_name(eid)
        return "[#{sname}..#{ename}]=#{flag_str}"
      end
    end
  end
  
  add_event(:code=>122,:names=>['ϐ̑','ϐ']) do
    def import_parameters(ecc,line)
      unless ecc.param =~ Regexp.union(VARIABLE_OPERATIONS)
        return []
      end
      operation = $&
      operation_id = VARIABLE_OPERATIONS.index(operation)
      values = ecc.param.split(/#{Regexp.escape(operation)}/).collect {|v| v.strip}
      if values.size != 2
        return []
      end
      variables = values[0].gsub(/\[|\]/,'').split(/\.\./).collect {|v| v.strip}
      eid = sid = Event_Compiler_Util.variable_id(variables[0])
      eid = Event_Compiler_Util.variable_id(variables[1]) if variables.size == 2
      if values[1] =~ /^-?[0-9]+$/
        # 萔
        variable_item_id = 0
        variable_value_data1 = values[1].to_i
      elsif values[1] =~ /^(#{Regexp.union(VARIABLE_ITEMS)})\s*\[(.+?)\]/
        variable_item = $1
        variable_value = $2
        variable_item_id = VARIABLE_ITEMS.index(variable_item)
        variable_value_data1 = 0
        variable_value_data2 = 0
        case variable_item_id
        when 0 # 萔
          variable_value_data1 = variable_value.to_i
        when 1 # ϐ
          variable_value_data1 = Event_Compiler_Util.variable_id(variable_value)
        when 2 # 
          tmp = variable_value.gsub(/\[|\]/,'').split(/\.\./).collect {|v| v.strip.to_i}
          if tmp.size == 2
            variable_value_data1 = tmp[0]
            variable_value_data2 = tmp[1]
          end
        when 3 # ACe
          variable_value_data1 = Event_Compiler_Util.item_id(variable_value)
        end
      end

      return [
        sid,eid,
        operation_id,
        variable_item_id,
        variable_value_data1,
        variable_value_data2
      ].compact
    end
    def export_parameters(ecc,event_command)
      (sid,eid,
       operation_id,
       variable_item_id,
       variable_value_data1,
       variable_value_data2) = event_command.parameters
      
      if sid == eid
        value_left = '['+ Event_Compiler_Util.variable_name(sid) +']' 
      else
        sname = Event_Compiler_Util.variable_name(sid)
        ename = Event_Compiler_Util.variable_name(eid)
        value_left = "[#{sname}..#{ename}]"
      end
      operation = VARIABLE_OPERATIONS[operation_id]
      case variable_item_id
      when 0
        # 萔
        value_right = variable_value_data1
      when 1 # ϐ
        value_right = 'ϐ['+Event_Compiler_Util.variable_name(variable_value_data1)+']'
      when 2 # 
        value_right = "[#{variable_value_data1}..#{variable_value_data2}]"
      when 3 # ACe
        name = Event_Compiler_Util.item_name(variable_value_data1)
        value_right = "ACe[#{name}]"
      end
      return "#{value_left}#{operation}#{value_right}"
    end
  end
  
  add_event(:code=>123,:names=>['ZtXCb`̑','ZtXCb`']) do
    def import_parameters(ecc,line)
      values = ecc.param.split(/=/).collect {|v| v.strip}
      if values.size == 2
        switch = values[0]
        flag = Event_Compiler_Util.parse_switch_value(values[1])
      end
      return [switch,flag]
    end
    def export_parameters(ecc,event_command)
      (switch,flag) = event_command.parameters
      flag = Event_Compiler_Util.switch_value_string(flag)
      "#{switch}=#{flag}"
    end
  end
  
  add_event(:code=>124,:names=>['^C}[̑','^C}[']) do
    def import_parameters(ecc,line)
      case ecc.param
      when Regexp.union('n','Jn')
        if ecc.param =~ /([0-9]+):([0-9]+)/
          sec = $1.to_i * 60 + $2.to_i
          return [0,sec]
        end
      when Regexp.union('~')
        return [1]
      end
      return [0,0]
    end
    def export_parameters(ecc,event_command)
      (flag,sec) = event_command.parameters
      case flag
      when 0
        (min,sec) = sec.divmod 60
        sec = "%02d" % sec
        return "n[#{min}:#{sec}]"
      when 1
        return "~"
      end
      return "n[0:00]"
    end
  end
  
  add_event(:code=>125,:names=>['S[h̑']) do
    def import_parameters(ecc,line)
      if ecc.param =~ /^\-/
        operation = 1 # 炷
      else
        operation = 0 # ₷
      end
      # operand_type : Iyh^Cv (0:萔 1:ϐ)
      if ecc.param =~ Regexp.union('ϐ')
        operand_type = 1
        operand = Event_Compiler_Util.variable_id(ecc.param)
      else
        operand_type = 0
        if ecc.param  =~ /([0-9]+)/
          operand = $1.to_i
        else
          operand = 0
        end
      end
      return [operation, operand_type, operand]
    end
    def export_parameters(ecc,event_command)
      (operation, operand_type, operand) = event_command.parameters
      operation = operation == 1 ? '-' : ''
      if operand_type == 1
        operand = 'ϐ[' + Event_Compiler_Util.variable_name(operand) + ']'
      end
      "#{operation}#{operand}"
    end
  end

  add_event(:code=>126,:names=>['ACȇ']) do
    def import_parameters(ecc,line)
      if ecc.param =~ /\[(.+?)\]\s*(\+|\-)\s*([0-9]+)/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3.to_i
        id = Event_Compiler_Util.item_id(name)
        return [id,op,0,num]
      elsif ecc.param =~ /\[(.+?)\]\s*(\+|\-)\s*#{Regexp.escape('ϐ')}\s*\[(.+?)\]/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3
        vid = Event_Compiler_Util.variable_id(num)
        id = Event_Compiler_Util.item_id(name)
        return [id,op,1,vid]
      end
      return [1,0,0,1]
    end
    def export_parameters(ecc,event_command)
      (id,op,flag,val) = event_command.parameters
      name = Event_Compiler_Util.item_name(id)
      op = op == 0 ? '+' : '-'
      if flag == 1
        val = 'ϐ['+Event_Compiler_Util.variable_name(val) + ']'
      end
      "[#{name}]#{op}#{val}"
    end
  end
  
  add_event(:code=>127,:names=>['̑']) do
    def import_parameters(ecc,line)
      if ecc.param =~ /\[(.+?)\]\s*(\+|\-)\s*([0-9]+)/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3.to_i
        id = Event_Compiler_Util.weapon_id(name)
        return [id,op,0,num]
      elsif ecc.param =~ /\[(.+?)\]\s*(\+|\-)\s*#{Regexp.escape('ϐ')}\s*\[(.+?)\]/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3
        vid = Event_Compiler_Util.variable_id(num)
        id = Event_Compiler_Util.weapon_id(name)
        return [id,op,1,vid]
      end
      return [1,0,0,1]
    end
    def export_parameters(ecc,event_command)
      (id,op,flag,val) = event_command.parameters
      name = Event_Compiler_Util.weapon_name(id)
      op = op == 0 ? '+' : '-'
      if flag == 1
        val = 'ϐ['+Event_Compiler_Util.variable_name(val) + ']'
      end
      "[#{name}]#{op}#{val}"
    end
  end
  
  add_event(:code=>128,:names=>['h̑']) do
    def import_parameters(ecc,line)
      if ecc.param =~ /\[(.+?)\]\s*(\+|\-)\s*([0-9]+)/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3.to_i
        id = Event_Compiler_Util.armor_id(name)
        return [id,op,0,num]
      elsif ecc.param =~ /\[(.+?)\]\s*(\+|\-)\s*#{Regexp.escape('ϐ')}\s*\[(.+?)\]/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3
        vid = Event_Compiler_Util.variable_id(num)
        id = Event_Compiler_Util.armor_id(name)
        return [id,op,1,vid]
      end
      return [1,0,0,1]
    end
    def export_parameters(ecc,event_command)
      (id,op,flag,val) = event_command.parameters
      name = Event_Compiler_Util.armor_name(id)
      op = op == 0 ? '+' : '-'
      if flag == 1
        val = 'ϐ['+Event_Compiler_Util.variable_name(val) + ']'
      end
      "[#{name}]#{op}#{val}"
    end
  end
  
  add_event(:code=>129,:names=>['AN^[̓ւ']) do
    def import_parameters(ecc,line)
      parameters = ecc.param.split(/,|A/).collect {|c| c.strip}
      actor_id = Event_Compiler_Util.actor_id(parameters[0])
      operation_type = 0
      initialize_actor = 0
      case parameters[0]
      when Regexp.union('')
        operation_type = 0
      when Regexp.union('O')
        operation_type = 1
      end
      if parameters.size == 2 and parameters[1] =~ Regexp.union('')
        initialize_actor = 1
      else
        initialize_actor = 0
      end
      return [actor_id,operation_type,initialize_actor]
    end
    def export_parameters(ecc,event_command)
      (actor_id,operation_type,initialize_actor) = event_command.parameters
      actor_name = Event_Compiler_Util.actor_name(actor_id)
      operation_type = operation_type == 0 ? '' : 'O'
      if initialize_actor == 1
        ["[#{actor_name}]#{operation_type}",'']
      else
        ["[#{actor_name}]#{operation_type}"]
      end
    end
  end
  
  add_event(:code=>131,:names=>['EBhEXL̕ύX'])
  
  add_event(:code=>132,:names=>['og BGM ̕ύX']) do
    def import_parameters(ecc,line)
      return [Event_Compiler_Util.create_audio_object(ecc.param)]
    end
    def export_parameters(ecc,event_command)
      return Event_Compiler_Util.create_audio_parameter(event_command.parameters[0])
    end
  end
  
  add_event(:code=>133,:names=>['ogI ME ̕ύX']) do
    def import_parameters(ecc,line)
      return [Event_Compiler_Util.create_audio_object(ecc.param)]
    end
    def export_parameters(ecc,event_command)
      return Event_Compiler_Util.create_audio_parameter(event_command.parameters[0])
    end
  end
  
  add_event(:code=>134,:names=>['Z[u֎~̕ύX']) do
    def import_parameters(ecc,line)
      if ecc.param =~ Regexp.union('')
        return [1]
      else
        return [0]
      end
    end
    def export_parameters(ecc,event_command)
      if event_command.parameters[0] == 1
        return ''
      else
        return 's'
      end
    end
  end
  
  add_event(:code=>135,:names=>['j[֎~̕ύX']) do
    def import_parameters(ecc,line)
      if ecc.param =~ Regexp.union('')
        return [1]
      else
        return [0]
      end
    end
    def export_parameters(ecc,event_command)
      if event_command.parameters[0] == 1
        return ''
      else
        return 's'
      end
    end
  end
  
  add_event(:code=>136,:names=>['GJEg֎~̕ύX']) do
    def import_parameters(ecc,line)
      if ecc.param =~ Regexp.union('')
        return [1]
      else
        return [0]
      end
    end
    def export_parameters(ecc,event_command)
      if event_command.parameters[0] == 1
        return ''
      else
        return 's'
      end
    end
  end
  
  # ꏊړFeXg,(1,1)
  # ꏊړF[eXg],(1,1)
  # ꏊړF[eXg],(1,1),
  # ꏊړF[eXg],(1,1),,tF[hȂ
  # ꏊړFϐ[}bvhc][wW][xW],,tF[hȂ
  add_event(:code=>201,:names=>['ꏊړ']) do
    def import_parameters(ecc,line)
      type = 0
      map_id = 1
      new_x = 0
      new_y = 0
      new_direction = 0
      transition = 0
      if ecc.param =~ /^#{Regexp.escape('ϐ[')}/
        # ϐw
        type = 1
        args = ecc.param.split(/,|A/).collect {|v|v.strip}
        if args[0] =~ /\[(.+?)\]\[(.+?)\]\[(.+?)\]/
          map_id = Event_Compiler_Util.variable_id($1)
          new_x = Event_Compiler_Util.variable_id($2)
          new_y = Event_Compiler_Util.variable_id($3)
        end
        if args.size >= 2
          new_direction = Event_Compiler_Util.direction(args[1])
        end
        if args.size >= 3
          transition = 1
        end
      else
        # ڎw
        type = 0
        args = ecc.param.split(/,|A/).collect {|v|v.strip}
        map_id = Event_Compiler_Util.parse_map_id(args[0])
        if args.size >= 3
          new_x = args[1].gsub(/\(|\)/,'').to_i
          new_y = args[2].gsub(/\(|\)/,'').to_i
        end
        if args.size >= 4
          new_direction = Event_Compiler_Util.parse_direction(args[3])
        end
        if args.size >= 5
          transition = 1
        end
      end
      return [type,map_id,new_x,new_y,new_direction,transition]
    end
    def export_parameters(ecc,event_command)
      (type,map_id,new_x,new_y,new_direction,transition) = event_command.parameters
      case type
      when 1
        # ϐw
        map_id_nm = Event_Compiler_Util.variable_name(map_id)
        new_x_nm = Event_Compiler_Util.variable_name(new_x)
        new_y_nm = Event_Compiler_Util.variable_name(new_y)
        moveto = "ϐ[#{map_id_nm}][#{new_x_nm}][#{new_y_nm}]"
      when 0
        # ڎw
        map_id_nm = Event_Compiler_Util.parse_map_name(map_id)
        moveto = "[#{map_id_nm}],(#{new_x},#{new_y})"
      end
      new_direction_nm = Event_Compiler_Util.direction_name(new_direction)
      transition_nm = transition == 0 ? 'tF[h' : 'tF[hȂ'
      [moveto,new_direction_nm,transition_nm]
    end
  end
  
  add_event(:code=>202,:names=>['Cxg̈ʒuݒ','Cxg̏ꏊݒ']) do
    def import_parameters(ecc,line)
      parameters = []
      values = ecc.param.split(/,|A/).collect {|v|v.strip}
      chara_id = ecc.get_character_id(values[0])
      if values[1] =~ /^\(/
        # ڎw
        value_type = 0
        new_x = values[1][/[0-9]+/].to_i
        new_y = values[2][/[0-9]+/].to_i
        new_direction = Event_Compiler_Util.direction(values[3])
      elsif values[1] =~ /^#{Regexp.escape('ϐ')}\[(.+?)\]\[(.+?)\]/
        # ϐw
        value_type = 1
        new_x = Event_Compiler_Util.variable_id($1.strip)
        new_y = Event_Compiler_Util.variable_id($2.strip)
        new_direction = Event_Compiler_Util.direction(values[2])
      elsif values[1] =~ /\[(.+?)\].*#{Regexp.escape('')}/
        # Cxgƌ
        value_type = 2
        new_x = ecc.get_character_id($1)
        new_y = 0
        new_direction = Event_Compiler_Util.direction(values[2])
      end
      return [chara_id,value_type,new_x,new_y,new_direction]
    end

    def export_parameters(ecc,event_command)
      chara_id,value_type,new_x,new_y,new_direction = event_command.parameters
      chara_name = ecc.get_character_name(chara_id)
      new_direction = Event_Compiler_Util.direction_name(new_direction)
      case value_type
      when 0
        # ڎw
        return [chara_name,"(#{new_x},#{new_y})",new_direction]
      when 1
        # ϐw
        new_x = Event_Compiler_Util.variable_name(new_x)
        new_y = Event_Compiler_Util.variable_name(new_y)
        return [chara_name,"ϐ[#{new_x}][#{new_y}]",new_direction]
      when 2
        # Cxgƌ
        to_chara = ecc.get_character_name(new_x)
        return [chara_name,to_chara + "ƌ",new_direction]
      end
      return []
    end
  end
  
  add_event(:code=>203,:names=>['}bṽXN[']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.size == 3
        direction = Event_Compiler_Util.direction(parameters[0])
        distance = parameters[1].to_i
        speed = parameters[2].to_i
        return [direction, distance, speed]
      end
      return [2,1,4]
    end
    def export_parameters(ecc,event_command)
      (direction, distance, speed) = event_command.parameters
      direction = Event_Compiler_Util.direction_name(direction)
      return [direction, distance, speed]
    end
  end
  
  add_event(:code=>204,:names=>['}bv̐ݒύX']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      case parameters[0]
      when 'pm}'
        conf_type = 0
        name = parameters[1]
        hue = parameters[2].to_i
        return [conf_type,name,hue]
      when 'tHO'
        conf_type = 1
        name = parameters[1]
        hue = parameters[2].to_i
        opacity = [[0,parameters[3].to_i].max,255].min
        blend_type = Event_Compiler_Util.blend_type(parameters[4])
        zoom = parameters[5].to_f
        sx = parameters[6].to_i
        sy = parameters[7].to_i
        return [conf_type,name,hue,opacity,blend_type,zoom,sx,sy]
      when 'ogobN'
        conf_type = 2
        name = parameters[1]
        return [conf_type,name]
      end
      return [0,'',0]
    end
    def export_parameters(ecc,event_command)
      (conf_type,name,hue,opacity,blend_type,zoom,sx,sy) = event_command.parameters
      case conf_type
      when 0
        conf_type = 'pm}'
        return [conf_type,name,hue]
      when 1
        conf_type = 'tHO'
        blend_type = Event_Compiler_Util.blend_type_name(blend_type)
        return [conf_type,name,hue,opacity,blend_type,zoom,sx,sy]
      when 2
        conf_type = 'ogobN'
        return [conf_type,name]
      end
      return ''
    end
  end
  
  add_event(:code=>205,:names=>['tHO̐FύX']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.size == 5
        tone = Tone.new(parameters[0].to_i,parameters[1].to_i,parameters[2].to_i,parameters[3].to_i)
        duration = parameters[4].to_i
      else
        tone = Tone.new(0,0,0,0) # FIXME
        duration = 0
      end
      return [tone, duration]
    end
    def export_parameters(ecc,event_command)
      (tone, duration) = event_command.parameters
      return [tone.red,tone.green,tone.blue,tone.gray,duration]
    end
  end
  
  add_event(:code=>206,:names=>['tHO̕sxύX']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      opacity = 255
      duration = 0
      case parameters.size
      when 1
        opacity = parameters[0].to_i
      when 2
        opacity = parameters[0].to_i
        duration = parameters[1].to_i
      end
      return [opacity, duration]
    end
    def export_parameters(ecc,event_command)
      return event_command.parameters
    end
  end
  
  add_event(:code=>207,:names=>['Aj[V̕\']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.size == 2
        character_id = ecc.get_character_id(parameters[0])
        animation_id = Event_Compiler_Util.animation_id(parameters[1])
      end
      return [character_id,animation_id]
    end
    def export_parameters(ecc,event_command)
      (character_id,animation_id) = event_command.parameters
      character = ecc.get_character_name(character_id)
      animation = Event_Compiler_Util.animation_name(animation_id)
      return [character,animation]
    end
  end
  
  add_event(:code=>208,:names=>['Ԃ̕ύX']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      return Event_Compiler_Util.parse_switch_value(parameters[0])
    end
    def export_parameters(ecc,event_command)
      return Event_Compiler_Util.switch_value_string(event_command.parameters[0])
    end
  end
  
  add_event(:code=>209,:names=>['ړ[g̐ݒ'],:related_code=>[509]) do
    def import(ecc,line)
      res = super(ecc,line)
      unless ecc.related
        @event_command = res
      end
      return res
    end
    def import_code(ecc,line)
      if ecc.related
        return 509
      end
      return super(ecc,line)
    end
    def import_parameters(ecc,line)
      unless ecc.related
        parameters = split_param(ecc.param)
        chara = ecc.get_character_id(parameters[0])
        @move_route = Move_Route_Util.create_move_route(ecc.param)
        return [chara,@move_route]
      else
        cmd = Move_Route_Util.create_move_command(ecc.param)
        @move_route.list.push(cmd)
        return [cmd]
      end
      return []
    end
    def export_name(ecc,event_command)
      case event_command.code
      when 509
        return RELATED_EVENT_PREFIX + '@@@@@@@'
      end
      super(ecc,event_command)
    end
    def export_parameters(ecc,event_command)
      unless ecc.related
        chara = ecc.get_character_name(event_command.parameters[0])
        params = Move_Route_Util.export_move_route_params(event_command.parameters[1])
        return [chara,*params]
      else
        return Move_Route_Util.export_move_command(event_command.parameters[0])
      end
      return []
    end
  end
  
  add_event(:code=>210,:names=>['ړ܂ŃEFCg'])
  
  add_event(:code=>221,:names=>['gWV'])
      
  add_event(:code=>222,:names=>['gWVs']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      transition_name = parameters[0]
      puts transition_name
      return transition_name
    end
    def export_parameters(ecc,event_command)
      return event_command.parameters[0]
    end
  end
  
  add_event(:code=>223,:names=>['ʂ̐FύX']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.size == 5
        tone = Tone.new(parameters[0].to_i,parameters[1].to_i,parameters[2].to_i,parameters[3].to_i)
        duration = parameters[4].to_i
      else
        tone = Tone.new(0,0,0,0) # FIXME
        duration = 0
      end
      return [tone, duration]
    end
    def export_parameters(ecc,event_command)
      (tone, duration) = event_command.parameters
      return [tone.red,tone.green,tone.blue,tone.gray,duration]
    end
  end
  
  add_event(:code=>224,:names=>['ʂ̃tbV']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      red = green = blue = duration = 0
      alpha = 255
      case parameters.size
      when 5
        (red,green,blue,alpha,duration) = parameters
      when 4
        (red,green,blue,duration) = parameters
      else
      end
      color = Color.new(red,green,blue,alpha)
      return [color, duration]
    end
    def export_parameters(ecc,event_command)
      (color, duration) = event_command.parameters
      return [color.red,color.green,color.blue,color.alpha,duration]
    end
  end
  
  add_event(:code=>225,:names=>['ʂ̃VFCN']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      power = speed = duration = 0
      if parameters.size == 3
        (power, speed, duration) = parameters
      end
      return [power, speed, duration]
    end
    def export_parameters(ecc,event_command)
      (power, speed, duration) = event_command.parameters
    end
  end
  
  add_event(:code=>231,:names=>['sN`̕\']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.size != 9
        return []
      end
      no = parameters[0].to_i
      name = parameters[1]
      if parameters[2] == '_'
        origin = 0
      else
        origin = 1
      end
      if parameters[3] =~ /^[0-9]+$/
        x = parameters[3].to_i
        y = parameters[4].to_i
        xy_type = 0
      elsif parameters[3] =~ Regexp.union('ϐ')
        x = Event_Compiler_Util.variable_id(parameters[3])
        y = Event_Compiler_Util.variable_id(parameters[4])
        xy_type = 1
      end
      zoom_x = parameters[5].to_f
      zoom_y = parameters[6].to_f
      opacity = parameters[7].to_i
      blend_type = Event_Compiler_Util.blend_type(parameters[8])
      return [no, name, origin, xy_type, x, y, zoom_x, zoom_y, opacity, blend_type]
    end
    def export_parameters(ecc,event_command)
      (no, name, origin, xy_type, x, y, zoom_x, zoom_y, opacity, blend_type) = event_command.parameters
      origin = ['_','S'][origin]
      if xy_type == 1
        x = 'ϐ[' + Event_Compiler_Util.variable_name(x) + ']'
        y = 'ϐ[' + Event_Compiler_Util.variable_name(y) + ']'
      end
      blend_type = Event_Compiler_Util.blend_type_name(blend_type)
      return [no, name, origin, x, y, zoom_x, zoom_y, opacity, blend_type]
    end
  end
  
  add_event(:code=>232,:names=>['sN`̈ړ']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      if parameters.size != 9
        return []
      end
      no = parameters[0].to_i
      duration = parameters[1].to_i
      if parameters[2] == '_'
        origin = 0
      else
        origin = 1
      end
      if parameters[3] =~ /^[0-9]+$/
        x = parameters[3].to_i
        y = parameters[4].to_i
        xy_type = 0
      elsif parameters[3] =~ Regexp.union('ϐ')
        x = Event_Compiler_Util.variable_id(parameters[3])
        y = Event_Compiler_Util.variable_id(parameters[4])
        xy_type = 1
      end
      zoom_x = parameters[5].to_f
      zoom_y = parameters[6].to_f
      opacity = parameters[7].to_i
      blend_type = Event_Compiler_Util.blend_type(parameters[8])
      return [no, duration, origin, xy_type, x, y, zoom_x, zoom_y, opacity, blend_type]
    end
    def export_parameters(ecc,event_command)
      (no, duration, origin, xy_type, x, y, zoom_x, zoom_y, opacity, blend_type) = event_command.parameters
      origin = ['_','S'][origin]
      if xy_type == 1
        x = 'ϐ[' + Event_Compiler_Util.variable_name(x) + ']'
        y = 'ϐ[' + Event_Compiler_Util.variable_name(y) + ']'
      end
      blend_type = Event_Compiler_Util.blend_type_name(blend_type)
      return [no, duration, origin, x, y, zoom_x, zoom_y, opacity, blend_type]
    end
  end
  
  add_event(:code=>233,:names=>['sN`̉]']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      no = parameters[0].to_i
      speed = parameters[1].to_i
      return [no,speed]
    end
    def export_parameters(ecc,event_command)
      (no, speed) = event_command.parameters
      return [no,speed]
    end
  end
  
  add_event(:code=>234,:names=>['sN`̐FύX']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      no = parameters[0].to_i
      if parameters.size == 6
        tone = Tone.new(parameters[1].to_i,parameters[2].to_i,parameters[3].to_i,parameters[4].to_i)
        duration = parameters[5].to_i
      else
        tone = Tone.new(0,0,0,0) # FIXME
        duration = 0
      end
      return [no, tone, duration]
    end
    def export_parameters(ecc,event_command)
      (no, tone, duration) = event_command.parameters
      return [no, tone.red,tone.green,tone.blue,tone.gray, duration]
    end
  end
  
  add_event(:code=>235,:names=>['sN`̏']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      no = parameters[0].to_i
      return [no]
    end
    def export_parameters(ecc,event_command)
      no = event_command.parameters[0]
      return [no]
    end
  end
  
  add_event(:code=>236,:names=>['V̐ݒ']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      weather_type = Event_Compiler_Util.weather_type_id(parameters[0])
      power = 5
      duration = 20
      if parameters.size > 1
        power = parameters[1].to_i
      end
      if parameters.size > 2
        duration = parameters[2].to_i
      end
      return [weather_type, power, duration]
    end
    def export_parameters(ecc,event_command)
      (weather_type, power, duration) = event_command.parameters
      weather_type = Event_Compiler_Util.weather_type_name(weather_type)
      return [weather_type, power, duration]
    end
  end
  
  add_event(:code=>241,:names=>['BGM ̉t']) do
    def import_parameters(ecc,line)
      return [Event_Compiler_Util.create_audio_object(ecc.param)]
    end
    def export_parameters(ecc,event_command)
      return Event_Compiler_Util.create_audio_parameter(event_command.parameters[0])
    end
  end
  
  add_event(:code=>242,:names=>['BGM ̃tF[hAEg']) do
    def import_parameters(ecc,line)
      parameters = split_param(ecc.param)
      time = 1
      if parameters[0] =~ /([0-9]+)/
        time = $1.to_i
      end
      return [time]
    end
    def export_parameters(ecc,event_command)
      time = event_command.parameters[0]
      return [time]
    end
  end
  
# XXX:
  add_event(:code=>245,:names=>['BGS ̉t']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>246,:names=>['BGS ̃tF[hAEg']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>247,:names=>['BGM / BGS ̋L']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>248,:names=>['BGM / BGS ̕A']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>249,:names=>['ME ̉t']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>250,:names=>['SE ̉t']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>251,:names=>['SE ̒~']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>301,:names=>['og̏']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>601,:names=>['ꍇ']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>602,:names=>['ꍇ']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>603,:names=>['ꍇ']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>302,:names=>['Vbv̏']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>303,:names=>['O͂̏']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>311,:names=>['HP ̑']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>312,:names=>['SP ̑']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>313,:names=>['Xe[g̕ύX']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>314,:names=>['S']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>315,:names=>['EXP ̑']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>316,:names=>['x̑']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>317,:names=>['p[^̑']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>318,:names=>['XL̑']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>319,:names=>['̕ύX']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>320,:names=>['AN^[̖OύX']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>321,:names=>['AN^[̃NXύX']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>322,:names=>['AN^[̃OtBbNύX']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>331,:names=>['Gl~[ HP ']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>332,:names=>['Gl~[ SP ']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>333,:names=>['Gl~[̃Xe[gύX']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>334,:names=>['Gl~[̏o']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>335,:names=>['Gl~[̕ϐg']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>336,:names=>['Gl~[̑S']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>337,:names=>['퓬Aj[V̕\']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>338,:names=>['_[W̏']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>339,:names=>['ANV̋']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>340,:names=>['og̒f']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>351,:names=>['j[ʂ̌Ăяo']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>352,:names=>['Z[uʂ̌Ăяo']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>353,:names=>['Q[I[o[']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>354,:names=>['^Cgʂɖ߂']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>355,:names=>['XNvg']) do
    def import_parameters(ecc,line)
    end
    def export_parameters(ecc,event_command)
    end
  end
  
  add_event(:code=>999,:names=>['xxx'])
end
